/*
          

JJMASeries.mqh  
PriceSeries.mqh 
FiltersLibroary.mqh
  (): MetaTrader\experts\include\

Heiken Ashi#.mq4
  (): MetaTrader\experts\indicators\

DF.DLL 
BDSP.DLL
LAPACK.DLL
mkl_support.dll
  (): MetaTrader\experts\libraries\
*/
//+------------------------------------------------------------------+  
//|         Digital Low Pass (FATL/SATL, KGLP) Filter   JDFilter.mq4 | 
//|      Digital Filter: Copyright (c) Sergey Iljukhin, Novosibirsk. |
//|                        mailto:sergey@tibet.ru  http://fx.qrz.ru/ |
//|  JJMASeries+Print_Filter: Copyright  2005,     Nikolay Kositsin | 
//|                                Khabarovsk, farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright (c) 2005, Sergey Iljukhin, Novosibirsk"
#property link      "mailto:sergey@tibet.ru"
/*
     MetaTrader 4.
 
  !      DLL 
      - bdsp.dll, lapack.dll, mkl_support.dll,
       C:\Windows\System32\    DF.dll  \experts\libraries\
 
    :
  
  1.    "Allow DLL import"  "CoFilter_sizeirm DLL function's call"   Options->Expert Advisors
  2.    C:\Windows\System32\  Bdsp.dll, lapack.dll, mkl_support.dll -   . 
 
    :
  
  Ftype -  : 0 -  (FATL/SATL/KGLP), 1 -  (KGHP), 
          2 -  (RBCI/KGBP), 3 -  (KGBS)
  P1 -      P1, 
  D1 -        D1, 
  A1 -        1, 
  P2 -      P2, 
  D2 -        D2, 
  A2 -        2, 
  Ripple -    , 
  Delay - , 

        P2,D2,A2 
   :
  : P1>D1
  : P1<D1
    : D2>P2>P1>D1
*/
#property indicator_chart_window
#property indicator_buffers 1
#property indicator_color1 Magenta
#import "DF.dll"
int DigitalFilter(int FType, int P1, int D1, int A1, int P2, int D2, int A2, double Ripple, int Delay, double& arr[]); 
//----    --------------------------------------------------------------------------------------------------+
extern int Length = 5;   //     
extern int Phase  = 100; //   ,    -100 ... +100,     ; 
extern int Shift  = 0;   // c     
extern int Input_Price_Customs = 0;// ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi High, 12-Heiken Ashi Low, 13-Heiken Ashi Open, 14-Heiken Ashi Close.)
extern int FilterType = 0;   //    .    ,    FilterType = 0
//----
//   
extern int    FType=0;// : 0 -  (FATL/SATL/KGLP), 1 -  (KGHP), 2 -  (RBCI/KGBP), 3 -  (KGBS)
extern int    P1=28;//  P1, 
extern int    D1=19;//    D1, 
extern int    A1=40;//    1, 
extern int    P2=0;//  P2, 
extern int    D2=0;//    D2, 
extern int    A2=0;//    2, 
extern int    Delay=0;//, 
extern double Ripple=0.08;//   ,  
extern bool   Print_Filter=false;/*     LOG      \MetaTrader\GBPJPY\EXPERTS\LOGS 
   "Print_Filter"   "true",   . "false" -   ,
"true"   */
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double Filter_Buffer[];
//----  
double Filter[1500];
int Filter_size;
//+------------------------------------------------------------------+  
//----+   JJMASeries 
//----+   JJMASeriesResize 
//----+   JJMASeriesAlert  
//----+   JMA_ErrDescr  
#include <JJMASeries.mqh> 
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+ 
//| JDFilter initialization function                                 | 
//+------------------------------------------------------------------+  
int init()
{

//+===     =======+
//+------+
switch(FilterType)
{
//+-------------------------------------+
case 1:{P1=10;D1=08;Ripple=0.864;}break;
//+-------------------------------------+
case 3:{P1=79;D1=35;Ripple=0.039;}break;//Satl
//+-------------------------------------+
//----+    , 
//----+  FiltersLibroary.mqh     (): MetaTrader\experts\include
#include <FiltersLibroary.mqh>
//+------+
default:{  }
//+-------------------------------------+
} 
//+=========================================================+
//----     DLL 
  if(IsDllsAllowed()!=false)
  {
//----     
   SetIndexStyle(0,DRAW_LINE);
//---- IndexShift    
   SetIndexShift(0,Shift);   
//----     
   SetIndexBuffer(0, Filter_Buffer);
//----   ,      
   SetIndexEmptyValue(0,0.0); 
//----        Filter[]
   Filter_size=DigitalFilter(FType, P1, D1, A1, P2, D2, A2, Ripple, Delay, Filter);  
//----          
   if (Filter_size>0){if(ArrayResize(Filter,Filter_size+1)==0){Print("     Filter");return(-1);}}
   else{Print("  .    .");return(-1);}
//----  
   SetIndexDrawBegin(0, Filter_size+30);
//----         
   SetIndexLabel(0,"Digital Low Pass (FATL/SATL, KGLP) Filter");
   IndicatorShortName("Digital Filter");
  }  
  else{Print("   (DLL) .    .");return(-1);}
//----    (    )     
  IndicatorDigits(Digits);
//----+      JJMASeries, nJMAnumber=1(    JJMASeries)
  if (JJMASeriesResize(1)!=1)return(-1);
//----       
  JJMASeriesAlert (0,"Length",Length);
  JJMASeriesAlert (1,"Phase", Phase);
  PriceSeriesAlert(Input_Price_Customs);
  
//----      log     \MetaTrader\GBPJPY\EXPERTS\LOGS 
if (Print_Filter==true)
{
Print("+-------------------------------------------------------------------------");
Print("+<<<<<<<<<<<<<<<<< ר    >>>>>>>>>>>>>>>>>>>");
Print("+-------------------------------------------------------------------------");
Print("+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - --");
Print("+------------------- <<<   >>> --------------------------");
Print("+ - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - --");
Print("FType="+FType+"/// : 0 -  (FATL/SATL/KGLP),  1 -  (KGHP), ");
Print("                       2 -  (RBCI/KGBP), 3 -  (KGBS)"  );
Print("P1="+P1+"///  P1, ");
Print("D1="+D1+"///    D1, ");
Print("A1="+A1+"///    1, ");
Print("P2="+P2+"///  P2, ");
Print("D2="+D2+"///    D2, ");
Print("A2="+A2+"///    2, ");
Print("Delay="+Delay+"///, ");
Print("Ripple="+Ripple+"///   , " );
double VEL;
for(int iii=0;iii<Filter_size;iii++)
 {
  VEL=Filter[iii];
  Print("+-------------------------------------------------------------------------");
  Print("+------------- <<<      >>> -------------");
  Print("///     Cloze[] --------------------------+");
  Print("+-------------------------------------------------------------------------");
  Print("FILTER="); 
  if (iii<Filter_size-1)
   {
    if (VEL>=0)Print("+"+DoubleToStr(VEL,8)+"*Close[bar+"+iii+"]");
    else Print(""+DoubleToStr(VEL,8)+"*Close[bar+"+iii+"]");
   }
  else
   {
    if (VEL>=0)Print("+"+DoubleToStr(VEL,8)+"*Close[bar+"+iii+"];");
    else Print(""+DoubleToStr(VEL,8)+"*Close[bar+"+iii+"];");
   }
  Print("+-------------------------------------------------------------------------");
  Print("+------------- <<<      >>> -------------");
  Print("///     Series_Buffer[] ------------------+");
  Print("+-------------------------------------------------------------------------");
  Print("FILTER="); 
  if (iii<Filter_size-1)
   {
    if (VEL>=0)Print("+"+DoubleToStr(VEL,8)+"*Series_Buffer[bar+"+iii+"]");
    else Print(""+DoubleToStr(VEL,8)+"*Series_Buffer[bar+"+iii+"]");
   }
  else
   {
    if (VEL>=0)Print("+"+DoubleToStr(VEL,8)+"*Series_Buffer[bar+"+iii+"];");
    else Print(""+DoubleToStr(VEL,8)+"*Series_Buffer[bar+"+iii+"];");
   }
  Print("+-------------------------------------------------------------------------");
  Print("+------------- <<<      >>> -------------");
  Print("///     PriceSeries -------------------------+");
  Print("+-------------------------------------------------------------------------");
  Print("FILTER="); 
  if (iii<Filter_size-1)
   {
    if (VEL>=0)Print("+"+DoubleToStr(VEL,8)+"*PriceSeries(Input_Price_Customs, bar+"+iii+")");
    else Print(""+DoubleToStr(VEL,8)+"*PriceSeries(Input_Price_Customs, bar+"+iii+")");
   }
  else
   {
    if (VEL>=0)Print("+"+DoubleToStr(VEL,8)+"*PriceSeries(Input_Price_Customs, bar+"+iii+");");
    else Print(""+DoubleToStr(VEL,8)+"*PriceSeries(Input_Price_Customs, bar+"+iii+");");
   }
   Print("+-------------------------------------------------------------------------");                                                                    
   Print("+---------- <<<      >>> -----------");
   Print("+-------------------------------------------------------------------------");
   Print("Filter_size="+Filter_size+";");
   {
    if (VEL>=0)Print("Filter["+iii+"]=+"+DoubleToStr(VEL,8)+";");
    else Print("Filter["+iii+"]="+DoubleToStr(VEL,8)+";");
   }
   Print("+-------------------------------------------------------------------------");                                                                    
   Print("+<<<<<<<<<<<<<<  ר    >>>>>>>>>>>>>>+");
   Print("+-------------------------------------------------------------------------");
  }
}
//---- 

//----  
return(0); 
} 
//+------------------------------------------------------------------+  
//| JDFilter                                                         | 
//+------------------------------------------------------------------+  
int start()
   {
//----       
if(Bars-1<=Filter_size)return(0);  
//----      
double Price,FILTER,Resalt;
//----+        
int reset,MaxBar,limit,bar,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----      
if (counted_bars>0) counted_bars--;
//----     ,         
MaxBar=Bars-1-Filter_size;
//----     ,         
limit=Bars-counted_bars-1; 
//----      ,         
//----            
if (limit>=MaxBar)
 {
  for(bar=limit;bar>=MaxBar;bar--)Filter_Buffer[bar]=0.0; 
  limit=MaxBar;
 }

//----+    
for(bar=limit;bar>=0;bar--)
 {
 FILTER=0.0;
  for(int ii=0;ii<=Filter_size;ii++)
   {
    //----+    PriceSeries     Price
    Price=PriceSeries(Input_Price_Customs, bar+ii);
    //----+     
    FILTER=FILTER+Filter[ii]*Price;
   }
  //----+ JMA   ,  nJMA.MaxBar     Filter_size
  //----+    JJMASeries   0,  nJMA.Phase  nJMA.Length      (nJMA.din=0)
  Resalt=JJMASeries(0,0,MaxBar,limit,Phase,Length,FILTER,bar,reset);
  //----+       
  if(reset!=0)return(-1);
  Filter_Buffer[bar]=Resalt;
     //----+
 }
//----    
return(0); 
} 
//+---------------------------------------------------------------------------+

